/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.router;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.router.VWRouterAdminNode;
import filenet.vw.apps.taskman.router.VWRouterPropertyPanel;
import filenet.vw.apps.taskman.router.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.server.IVWRouter;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VWRouterNode
extends VWTaskBaseNode {
    private VWRouterPropertyPanel m_propertyPanel = null;
    private VWRouterAdminNode m_routerAdminNode = null;
    private IVWRouter m_router = null;
    private String m_authToken = "";
    private String m_workflowServer = null;
    private String m_localHost = null;
    private String m_debugLevel = VWResource.Off;
    private Integer m_region = new Integer(1);
    private Integer m_routerPort = new Integer(32771);
    private Integer m_ppmPort = new Integer(32771);
    private Integer m_rmiBacklog = new Integer(100);
    private boolean m_saveXML = true;
    private Integer m_brokerPort = new Integer(32780);
    private static final String ROUTER_PREFIX = "FileNET.VW.VWRouter.";
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("router_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("router_16.gif");
    protected static final ImageIcon nodeIconS32 = VWImageLoader.createImageIcon("router_stop_32.gif");
    protected static final ImageIcon nodeIconS16 = VWImageLoader.createImageIcon("router_stop_16.gif");

    public VWRouterNode(int routerPort, boolean autostartEnabled) throws Exception {
        super(5);
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.m_routerPort = new Integer(routerPort);
        this.setAutoStartEnabled(false);
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel = new VWRouterPropertyPanel(this);
            this.getContentPane().setPropertyPanel(this.m_propertyPanel, false, false);
        }
    }

    public VWRouterNode(Node routerXMLNode, int routerPort) throws Exception {
        super(5);
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.m_routerPort = new Integer(routerPort);
        this.fromXML(routerXMLNode);
        this.setAutoStartEnabled(false);
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel = new VWRouterPropertyPanel(this);
            this.getContentPane().setPropertyPanel(this.m_propertyPanel, false, false);
        }
    }

    public void refresh() {
    }

    public void setPropertyPanel(VWRouterPropertyPanel panel) {
        this.m_propertyPanel = panel;
        this.getContentPane().setPropertyPanel(this.m_propertyPanel, true, true);
    }

    public VWRouterPropertyPanel getPropertyPanel() {
        return this.m_propertyPanel;
    }

    public void setParent(VWRouterAdminNode parent) {
        this.m_routerAdminNode = parent;
    }

    public void setRouterName(String name) throws VWException {
        if (VWStringUtils.compare(this.getName(), name) != 0) {
            if (this.m_routerAdminNode == null) {
                this.m_routerAdminNode = (VWRouterAdminNode)this.getParent();
            }
            if (this.m_routerAdminNode != null && this.m_routerAdminNode.isRouterNameInUse(name)) {
                throw new VWException("vw.apps.taskman.router.RouterAlreadyExists", "A router with the name ''{0}'' already exists.  Please choose another name.", name);
            }
            super.setName(name);
        }
    }

    public String getRouterName() {
        return super.getName();
    }

    public boolean saveXML() {
        return this.m_saveXML;
    }

    public IVWRouter getRouter() {
        return this.m_router;
    }

    public Integer getIsolatedRegion() {
        return this.m_region;
    }

    public Integer getRouterPort() {
        return this.m_routerPort;
    }

    public Integer getPPMPort() {
        return this.m_ppmPort;
    }

    public Integer getBrokerPort() {
        return this.m_brokerPort;
    }

    public String getLocalHost() {
        if (this.m_localHost == null) {
            return "";
        }
        return this.m_localHost;
    }

    public Integer getRMIBacklog() {
        return this.m_rmiBacklog;
    }

    public String getWorkflowServer() {
        return this.m_workflowServer;
    }

    public String getDebugLevel() {
        return this.m_debugLevel;
    }

    public void setIsolatedRegion(Integer isolatedRegion) {
        this.m_region = isolatedRegion;
    }

    public void setPPMPort(Integer ppmPort) {
        this.m_ppmPort = ppmPort;
    }

    public void setBrokerPort(Integer brokerPort) {
        this.m_brokerPort = brokerPort;
    }

    public void setLocalHost(String hostName) {
        if (hostName != null) {
            this.m_localHost = hostName.trim().equals("") ? null : hostName;
        }
    }

    public void setDebugLevel(String debugLevel) throws RemoteException {
        this.m_debugLevel = debugLevel;
        if (this.m_router != null && this.m_debugLevel != null) {
            int intDebugLevel = 0;
            if (VWStringUtils.compare(this.m_debugLevel, VWResource.Off) != 0) {
                intDebugLevel = Integer.parseInt(this.m_debugLevel);
            }
            this.m_router.setDebugLevel(intDebugLevel);
        }
    }

    public void setWorkflowServer(String serverName) {
        this.m_workflowServer = serverName;
    }

    public String getOptions() {
        return this.m_authToken;
    }

    public void setOptions(String options) {
        this.m_authToken = options;
    }

    public void setRMIBackLog(Integer rmiBacklog) {
        this.m_rmiBacklog = rmiBacklog;
    }

    public void delete() {
        if (this.m_routerAdminNode == null) {
            this.m_routerAdminNode = (VWRouterAdminNode)this.getParent();
        }
        this.m_routerAdminNode.removeSavedRouter(this);
        super.delete();
        this.m_propertyPanel = null;
    }

    public boolean isStopped() {
        return true;
    }

    public boolean isStarted() {
        return false;
    }

    public String getStatus() {
        return VWResource.Stopped;
    }

    public static String parseRouterName(String registryName) {
        int index = registryName.lastIndexOf(".");
        if (index != -1) {
            return registryName.substring(index + 1);
        }
        return registryName;
    }

    public Icon getIcon16() {
        if (this.isStarted()) {
            return nodeIcon16;
        }
        return nodeIconS16;
    }

    public Icon getIcon32() {
        if (this.isStarted()) {
            return nodeIcon32;
        }
        return nodeIconS32;
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_TaskManager + "router.htm");
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.DELETE) == 0) {
                this.delete();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public String[] getActions() {
        String[] actions = new String[]{VWTaskActionCommand.DELETE, "Add Separator", VWTaskActionCommand.HELP};
        return actions;
    }

    public boolean isActionEnabled(String actionCMD) {
        return true;
    }

    public boolean showStartIcon() {
        return false;
    }

    public boolean showStopIcon() {
        return false;
    }

    public boolean showDeleteIcon() {
        return true;
    }

    public boolean showPropertyIcon() {
        return true;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ROUTER_INDENT = "\t\t\t";
        String ATTRIB_INDENT = ROUTER_INDENT + "\t";
        theBuffer.append(ROUTER_INDENT + "<Router\n");
        theBuffer.append(ATTRIB_INDENT + this.getAutoStartAttributeString() + "\n");
        theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWTaskXMLHandler.toXMLString(this.getName()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "ServerURL=\"" + VWTaskXMLHandler.toXMLString(this.m_workflowServer) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Region=\"" + this.m_region.toString() + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "PPMPort=\"" + this.m_ppmPort.toString() + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "BrokerPort=\"" + this.m_brokerPort.toString() + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "RMIBacklog=\"" + this.m_rmiBacklog.toString() + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Options=\"" + VWTaskXMLHandler.toXMLString(this.m_authToken) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "LocalHost=\"" + VWTaskXMLHandler.toXMLString(this.m_localHost) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "DebugLevel=\"" + VWTaskXMLHandler.toXMLString(this.m_debugLevel) + "\"/>\n");
    }

    private void fromXML(Node aNode) {
        if (aNode.getNodeType() != 1) {
            return;
        }
        try {
            Element ele = (Element)aNode;
            this.setAutoStartEnabled(ele);
            if (ele.getAttributeNode("Name") != null) {
                this.setRouterName(ele.getAttribute("Name"));
            }
            if (ele.getAttributeNode("ServerURL") != null) {
                this.setWorkflowServer(ele.getAttribute("ServerURL"));
            }
            if (ele.getAttributeNode("LocalHost") != null) {
                this.setLocalHost(ele.getAttribute("LocalHost"));
            }
            if (ele.getAttributeNode("Options") != null) {
                this.setOptions(ele.getAttribute("Options"));
            }
            if (ele.getAttributeNode("DebugLevel") != null) {
                try {
                    this.setDebugLevel(ele.getAttribute("DebugLevel"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                if (ele.getAttributeNode("Region") != null) {
                    this.setIsolatedRegion(new Integer(ele.getAttribute("Region")));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                if (ele.getAttributeNode("RMIBacklog") != null) {
                    this.setRMIBackLog(new Integer(ele.getAttribute("RMIBacklog")));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                if (ele.getAttributeNode("PPMPort") != null) {
                    this.setPPMPort(new Integer(ele.getAttribute("PPMPort")));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                if (ele.getAttributeNode("BrokerPort") != null) {
                    this.setBrokerPort(new Integer(ele.getAttribute("BrokerPort")));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        catch (Exception e) {
            VWDebug.logError("Error parsing router xml: " + e.getLocalizedMessage());
        }
    }
}

